<?php

/**
 * This is the model class for table "Szkola".
 *
 * The followings are the available columns in table 'Szkola':
 * @property double $id
 * @property string $nazwa
 * @property string $miasto
 * @property double $idMapy
 */
class Szkola extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Szkola the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Szkola';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idMapy', 'required'),
			array('idMapy', 'numerical'),
			array('nazwa, miasto', 'length', 'max'=>128),

			array('id, nazwa, miasto, idMapy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'klasy'=>array(self::HAS_MANY, 'Klasa', 'idSzkoly'),
			'idMapy0'=>array(self::BELONGS_TO, 'Mapa', 'idMapy'),
			'nauczyciel'=>array(self::HAS_MANY, 'Admin', 'idSzkoly')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Szkola', 'ID'),
			'nazwa'=>Yii::t('Szkola', 'Nazwa szkoły'),
			'miasto'=>Yii::t('Szkola', 'Miasto'),
			'idMapy'=>Yii::t('Szkola', 'Mapa'),
		);
	}

	public static function getClasses($schoolId)
	{
		$sql = 'SELECT t."id", t."nazwa"
			FROM "Klasa" t
			WHERE t."idSzkoly" = '.$schoolId.'
			ORDER BY t."nazwa"';

		return Yii::app()->db->createCommand($sql)->queryAll();
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare(Yii::app()->db->quoteColumnName('id'), $this->id);
		$criteria->compare('LOWER("nazwa")', strtolower($this->nazwa), true);
		$criteria->compare('LOWER("miasto")', strtolower($this->miasto), true);
		$criteria->compare(Yii::app()->db->quoteColumnName('idMapy'), $this->idMapy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function getCities()
	{
		$sql = 'SELECT DISTINCT "miasto"
			FROM "Szkola"
			ORDER BY "miasto"';

		return Yii::app()->db->createCommand($sql)->queryColumn();
	}

	public static function getByCity($cityName)
	{
		$sql = 'SELECT "id", "nazwa"
			FROM "Szkola"
			WHERE "miasto"=\''.Yii::app()->db->quoteValue($cityName).'\'';

		return Yii::app()->db->createCommand($sql)->queryAll();
	}

	public function getAllStatistics()
	{
		$sql = 'SELECT "punkty", "idSzkoly" as "id", t2."nazwa"
			FROM "PunktySzkoly" t
			LEFT JOIN "Szkola" t2 ON t."idSzkoly" = t2."id"
			ORDER BY "punkty" DESC';

		$schoolid = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolid))
		{
			$sql = 'SELECT "punkty", "idSzkoly" as "id", t2."nazwa"
				FROM "PunktySzkoly" t
				LEFT JOIN "Szkola" t2 ON t."idSzkoly" = t2."id"
				WHERE t2."id" = '.Yii::app()->user->getState('schoolId').'
				ORDER BY "punkty" DESC';
		}

		return new CSqlDataProvider($sql,array(
			'pagination'=>false
		));
	}
}
